% Compute the hamming distances between binary vectors in compact format
%
% Usage:  D = yael_hamming(X, Y);
% Input:  X and Y are set of bit vectors, 1 vector per column
% Output: Set of Hamming distances, in uint16 format

function D = yael_hamming(X, Y);

% Tabulate Hamming distance.
tabhamdis = uint16([...
    0 1 1 2 1 2 2 3 1 2 2 3 2 3 3 4 1 2 2 3 2 3 ...
    3 4 2 3 3 4 3 4 4 5 1 2 2 3 2 3 3 4 2 3 3 4 ...
    3 4 4 5 2 3 3 4 3 4 4 5 3 4 4 5 4 5 5 6 1 2 ...
    2 3 2 3 3 4 2 3 3 4 3 4 4 5 2 3 3 4 3 4 4 5 ...
    3 4 4 5 4 5 5 6 2 3 3 4 3 4 4 5 3 4 4 5 4 5 ...
    5 6 3 4 4 5 4 5 5 6 4 5 5 6 5 6 6 7 1 2 2 3 ...
    2 3 3 4 2 3 3 4 3 4 4 5 2 3 3 4 3 4 4 5 3 4 ...
    4 5 4 5 5 6 2 3 3 4 3 4 4 5 3 4 4 5 4 5 5 6 ...
    3 4 4 5 4 5 5 6 4 5 5 6 5 6 6 7 2 3 3 4 3 4 ...
    4 5 3 4 4 5 4 5 5 6 3 4 4 5 4 5 5 6 4 5 5 6 ...
    5 6 6 7 3 4 4 5 4 5 5 6 4 5 5 6 5 6 6 7 4 5 ...
    5 6 5 6 6 7 5 6 6 7 6 7 7 8]);

nX = size(X, 2);
dd = size(X, 1);  % True dimensionality is dd*8
nY = size(Y, 2);
assert (size(Y, 1) == dd);

D = zeros(nX, nY, 'uint16');

for i = 1:nX
a = repmat(X(:,i), 1, nY);
b = uint16 (bitxor (a, Y));
c = tabhamdis (b + 1);
  D (i, :) = sum (c);
end
          
